﻿using System.Collections.Generic;
using System.Linq;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public class EventRemindersManager
    {
        public static IEnumerable<ReferralFollowUp> GetEventReminders(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            bool? REMINDER,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new EventRemindersDB();

            var results = db.GetEventReminders(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME,
                REMINDER,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int GetEventRemindersCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            bool? REMINDER,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new EventRemindersDB();

            return db.GetEventRemindersCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME,
                REMINDER);
        }

        public static List<KeyValuePair<int, string>> GetBiomonitoringFollowupDurations(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            List<KeyValuePair<int, string>> results = null;

            var items = STD_DURATIONManager
                .GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                .OrderBy(i => i.SORT_ORDER);

            if (items != null && items.Any())
                results = items
                    .Select(i => new KeyValuePair<int, string>(i.ID, i.NAME))
                    .ToList();

            return results;
        }
    }
}
